#include<stdio.h>
#include<vector>
#include<queue>
#include<map>

struct naselje
{
	int id;
	int index;
	int udaljenost = 0;
	std::vector<naselje*> susedi;
	bool visited = false;
};

std::map<int, naselje> naselja;
std::vector<std::map<int, naselje>::iterator> niz_naselja;
std::queue<naselje*> red_pretrage;

//l je donja granica indexa, r je gornja
//x je ID naselja od kog krecemo
int look_for_village(int l, int r, int x)
{
	int najdalje = 0;

	red_pretrage.push(&naselja[x]);
	naselja[x].udaljenost = 0;

	int preostalih_naselja = r - l + 1;
	while (!red_pretrage.empty())
	{
		naselje* n = red_pretrage.front();
		red_pretrage.pop();

		//Provera da li je naselje jedno od trazenih
		if ((n->index >= l) && (n->index <= r))
		{
			preostalih_naselja--;
			if (preostalih_naselja == 0)
				return n->udaljenost;
		}

		//Dodavanje svih suseda naselja na kraj reda
		for (auto& s : n->susedi)
		{
			if (!s->visited)
			{
				s->udaljenost = n->udaljenost + 1;
				red_pretrage.push(s);
			}
		}

		n->visited = true;
	}
	return(najdalje);
};

void swap_village(int index1, int index2)
{
	naselje *n1, *n2;
	n1 = &niz_naselja[index1 - 1]->second;
	n2 = &niz_naselja[index2 - 1]->second;

	n1->index = index2;
	n2->index = index1;

	auto temp = niz_naselja[index1 - 1];
	niz_naselja[index1 - 1] = niz_naselja[index2 - 1];
	niz_naselja[index2 - 1] = temp;
}

void unvisit()
{
	red_pretrage = std::queue<naselje*>();
	for (auto& n : naselja)
	{
		n.second.visited = false;
	}
}

int main()
{
	int br_naselja;
	
	std::vector<int> rezultati;

	//Ucitavanje naselja
	scanf("%d", &br_naselja);
	for (int i = 1; i <= br_naselja; i++)
	{
		int id_naselja;
		scanf("%d", &id_naselja);
		naselje n = { id_naselja, i, 0 };
		naselja[id_naselja] = n;
		niz_naselja.push_back(naselja.find(id_naselja));
	}

	for (int i = 1; i < br_naselja; i++)
	{
		int id1, id2;
		scanf("%d%d", &id1, &id2);

		naselja[id1].susedi.push_back(&naselja[id2]);
		naselja[id2].susedi.push_back(&naselja[id1]);
	}

	int br_dogadjaja;
	scanf("%d", &br_dogadjaja);

	for (int i = 0; i < br_dogadjaja; i++)
	{
		int instrukcija;
		scanf("%d", &instrukcija);
		if (instrukcija == 1)
		{
			int a, b;
			scanf("%d%d", &a, &b);
			swap_village(a, b);
		}
		else if (instrukcija == 2)
		{
			int l, r, x;
			scanf("%d%d%d", &l, &r, &x);
			int rezultat = look_for_village(l, r, x);
			rezultati.push_back(rezultat);
			unvisit();
		}
	}

	for (int i = 0; i < rezultati.size(); i++)
	{
		printf("%d", rezultati[i]);
		if (i != rezultati.size() - 1)
			printf("\n");
	}

	return 0;
}